package ru.yandex.partner.jsonapi.models.user

import org.springframework.context.MessageSource
import org.springframework.context.annotation.Bean
import org.springframework.context.annotation.Configuration
import ru.yandex.partner.core.entity.common.editablefields.EditableFieldsService
import ru.yandex.partner.core.entity.dictionary.moderationreason.ModerationReasonService
import ru.yandex.partner.core.entity.user.model.BaseUser
import ru.yandex.partner.core.entity.user.model.User
import ru.yandex.partner.core.entity.user.multistate.UserMultistateExpressionParser
import ru.yandex.partner.core.entity.user.multistate.UserMultistateGraph
import ru.yandex.partner.core.service.integration.balance.BalanceDocumentService
import ru.yandex.partner.jsonapi.crnk.filter.description.provider.ModerationReasonDictionaryValuesProvider
import ru.yandex.partner.jsonapi.crnk.filter.description.provider.RolesDictionaryValuesProvider
import ru.yandex.partner.jsonapi.crnk.filter.description.provider.UserTypeDictionaryValuesProvider
import ru.yandex.partner.jsonapi.crnk.multistate.MultistateService
import ru.yandex.partner.jsonapi.crnk.user.ActiveContractCrnkMapper
import ru.yandex.partner.jsonapi.crnk.user.AdfoxInfoCrnkMapper
import ru.yandex.partner.jsonapi.crnk.user.RoleCrnkMapper
import ru.yandex.partner.jsonapi.crnk.user.authorization.UserAuthorizationPolicy
import ru.yandex.partner.jsonapi.crnk.user.authorization.actions.UserActionsAuthorizationService
import ru.yandex.partner.jsonapi.models.CommonFunctionComposite
import ru.yandex.partner.jsonapi.models.DependsHolder
import ru.yandex.partner.jsonapi.models.common.ApiFieldsDependsModelPart
import ru.yandex.partner.jsonapi.models.user.parts.ApiUserActionsModelPart
import ru.yandex.partner.jsonapi.models.user.parts.ApiUserMultistateModelPart
import ru.yandex.partner.jsonapi.models.user.parts.ApiUserPart
import ru.yandex.partner.jsonapi.utils.ConfigurationUtils
import ru.yandex.partner.libs.auth.facade.AuthenticationFacade

@Configuration
class ApiUserConfiguration {

    @Bean
    fun apiUserModel(
        apiUserModelMetaData: ApiUserModelMetaData,
        multistateService: MultistateService,
        moderationReasonService: ModerationReasonService,
        authenticationFacade: AuthenticationFacade,
        userActionsAuthorizationService: UserActionsAuthorizationService,
        userMultistateGraph: UserMultistateGraph,
        userMultistateExpressionParser: UserMultistateExpressionParser,
        rolesDictionaryValuesProvider: RolesDictionaryValuesProvider,
        balanceDocumentService: BalanceDocumentService,
        userTypeDictionaryValuesProvider: UserTypeDictionaryValuesProvider,
        moderationReasonDictionaryValuesProvider: ModerationReasonDictionaryValuesProvider,
        userAuthorizationPolicy: UserAuthorizationPolicy?,
        activeContractCrnkMapper: ActiveContractCrnkMapper,
        adfoxInfoCrnkMapper: AdfoxInfoCrnkMapper,
        roleCrnkMapper: RoleCrnkMapper,
        editableFieldsService: EditableFieldsService<BaseUser>,
        messageSource: MessageSource
    ): ApiUserModel {
        val modelParts = mutableListOf(
            ApiUserPart(
                moderationReasonService, authenticationFacade, userMultistateGraph,
                activeContractCrnkMapper, adfoxInfoCrnkMapper, roleCrnkMapper, userMultistateExpressionParser,
                rolesDictionaryValuesProvider, balanceDocumentService,
                userTypeDictionaryValuesProvider, moderationReasonDictionaryValuesProvider,
                messageSource
            ),
            ApiUserActionsModelPart(
                userActionsAuthorizationService,
                userMultistateGraph,
                multistateService
            ),
            ApiUserMultistateModelPart(multistateService, User.MULTISTATE),
            ApiFieldsDependsModelPart<User>(FIELDS_DEPENDS).setHide(true)
        )
        val apiFieldsAvailableRules = ConfigurationUtils.configureAvailableFields(
            modelParts = modelParts,
            functionComposite = CommonFunctionComposite(),
            authenticationFacade = authenticationFacade
        )

        val apiFieldsEditableRules = ConfigurationUtils.configureEditableFields(
            modelParts = modelParts,
            functionComposite = CommonFunctionComposite(),
            authenticationFacade = authenticationFacade,
            actionsAuthorizationService = userActionsAuthorizationService,
            editableFieldsService = editableFieldsService
        )

        return ApiUserModel(
            apiUserModelMetaData, modelParts, userAuthorizationPolicy,
            apiFieldsAvailableRules, apiFieldsEditableRules
        )
    }

    companion object {
        private val FIELDS_DEPENDS = DependsHolder()
    }
}
