package ru.yandex.partner.jsonapi.models.user;

import java.util.List;
import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.partner.core.entity.user.filter.UserFilters;
import ru.yandex.partner.core.entity.user.model.User;
import ru.yandex.partner.core.filter.meta.MetaFilter;
import ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRulesService;
import ru.yandex.partner.jsonapi.crnk.fields.EditableData;
import ru.yandex.partner.jsonapi.models.AbstractApiModel;
import ru.yandex.partner.jsonapi.models.ApiModelPart;
import ru.yandex.partner.libs.authorization.policy.base.Policy;

@ParametersAreNonnullByDefault
public class ApiUserModel extends AbstractApiModel<User> {
    private final Policy<User> policy;

    public ApiUserModel(ApiUserModelMetaData apiUserModelMetaData, List<ApiModelPart<User>> parts, Policy<User> policy,
                        ApiFieldsAccessRulesService<User> userApiFieldsAvailableRules,
                        ApiFieldsAccessRulesService<EditableData<User>> userApiFieldsEditableRules) {
        super(apiUserModelMetaData, parts, userApiFieldsAvailableRules, userApiFieldsEditableRules);
        this.policy = policy;
    }

    @Override
    public MetaFilter<? super User, Long> getIdFilter() {
        return UserFilters.ID;
    }

    @Override
    public User createNewInstance() {
        return new User();
    }

    @Override
    public Policy<User> getPolicy() {
        return policy;
    }

    @Override
    public Map<String, Map<String, String>> getRelationshipsLinks() {
        return Map.of();
    }
}
