package ru.yandex.partner.jsonapi.models.user;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.validation.presentation.DefectPresentationRegistry;
import ru.yandex.partner.core.action.ActionPerformer;
import ru.yandex.partner.core.entity.ModelQueryService;
import ru.yandex.partner.core.entity.user.model.User;
import ru.yandex.partner.jsonapi.crnk.authorization.request.RequestAuthorizationService;
import ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsService;
import ru.yandex.partner.jsonapi.crnk.user.authorization.actions.UserActionsAuthorizationService;
import ru.yandex.partner.jsonapi.models.AbstractApiService;
import ru.yandex.partner.jsonapi.models.ApiModel;
import ru.yandex.partner.jsonapi.models.user.actions.UserActionsService;
import ru.yandex.partner.libs.i18n.TranslatableError;

@ParametersAreNonnullByDefault
@Service
public class ApiUserService extends AbstractApiService<User> {

    @Autowired
    @SuppressWarnings("checkstyle:parameternumber")
    public ApiUserService(
            ActionPerformer actionPerformer,
            DefectPresentationRegistry<TranslatableError> defectRegistry,
            RequestAuthorizationService requestAuthorizationService,
            UserActionsAuthorizationService actionsAuthorizationService,
            ApiFieldsService<User> apiFieldsService,
            ApiModel<User> apiModel,
            ModelQueryService<User> modelQueryService,
            UserActionsService userActionsService
    ) {
        super(
                defectRegistry,
                modelQueryService,
                requestAuthorizationService,
                actionsAuthorizationService,
                apiFieldsService,
                apiModel,
                userActionsService,
                actionPerformer
        );
    }

    @Override
    public String coreIdToApiId(Long id) {
        return String.valueOf(id);
    }

    @Override
    public Long apiIdToCoreId(String id) {
        return Long.valueOf(id);
    }

    @Override
    public boolean needToSetSelfLink() {
        return false;
    }

}
