package ru.yandex.partner.jsonapi.models.user.parts;

import java.util.function.BiConsumer;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.partner.core.entity.user.model.User;
import ru.yandex.partner.jsonapi.crnk.authorization.actions.AbstractActionsAuthorizationService;
import ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRules;
import ru.yandex.partner.jsonapi.crnk.multistate.MultistateService;
import ru.yandex.partner.jsonapi.models.common.ApiActionsModelPart;
import ru.yandex.partner.libs.multistate.graph.AbstractMultistateGraph;

import static ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRules.checkable;
import static ru.yandex.partner.jsonapi.models.user.parts.ApiModelAvailability.selfViewOrCanViewAllFields;

@ParametersAreNonnullByDefault
public class ApiUserActionsModelPart extends ApiActionsModelPart<User> {
    public ApiUserActionsModelPart(
            AbstractActionsAuthorizationService<User> abstractActionsAuthorizationService,
            AbstractMultistateGraph<? super User, ?> multistateGraph,
            MultistateService multistateService) {
        super(abstractActionsAuthorizationService.getAllRequiredProperties(), abstractActionsAuthorizationService,
                multistateGraph, multistateService);
    }

    protected BiConsumer<String, ApiFieldsAccessRules.Builder<User>> getAvailableConsumer() {
        return checkable(selfViewOrCanViewAllFields());
    }
}
