package ru.yandex.partner.jsonapi.models.user.parts;

import java.util.function.BiConsumer;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.model.ModelProperty;
import ru.yandex.partner.core.entity.user.model.User;
import ru.yandex.partner.core.entity.user.model.prop.UserWithMultistateMultistatePropHolder;
import ru.yandex.partner.core.multistate.Multistate;
import ru.yandex.partner.core.multistate.user.UserStateFlag;
import ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRules;
import ru.yandex.partner.jsonapi.crnk.multistate.MultistateService;
import ru.yandex.partner.jsonapi.crnk.user.UserRightsEnum;
import ru.yandex.partner.jsonapi.models.common.ApiMultistateModelPart;

import static ru.yandex.partner.jsonapi.models.user.parts.ApiModelAvailability.selfViewOrCanViewAllFieldsAndHasRightConsumer;

@ParametersAreNonnullByDefault
public class ApiUserMultistateModelPart
        extends ApiMultistateModelPart<UserWithMultistateMultistatePropHolder, User, UserStateFlag> {

    public ApiUserMultistateModelPart(
            MultistateService multistateService,
            ModelProperty<UserWithMultistateMultistatePropHolder,
                    ? extends Multistate<UserStateFlag>> multistateModelProperty) {
        super(multistateService, multistateModelProperty);
    }

    @Override
    protected BiConsumer<String, ApiFieldsAccessRules.Builder<User>> getAvailableConsumer() {
        return selfViewOrCanViewAllFieldsAndHasRightConsumer(UserRightsEnum.VIEW_FIELD__MULTISTATE);
    }
}
