package ru.yandex.partner.jsonapi.response;

import org.springframework.http.HttpStatus;

import ru.yandex.partner.libs.exceptions.HttpErrorStatusEnum;

/**
 * Вычисляет ID ошибки для исключения
 * https://yandex.ru/dev/partner/doc/objects/concepts/error-codes-docpage/
 * Пока работет только во время авторизации, нужно будет добавить мэппинги для прочих ошибок
 */
public class PartnerExceptionToErrorIdMapper implements ExceptionToErrorIdMapper {

    @Override
    public int mapHttpStatusToErrorId(int httpStatus) {
        return HttpErrorStatusEnum.getIdByHttpStatus(HttpStatus.valueOf(httpStatus));
    }

}
