package ru.yandex.partner.jsonapi.response.dto;


import java.util.Map;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.partner.libs.extservice.saas.response.AttributeNames;

public class UacSaasAppDto {
    private static final String ICON_URL = "https://avatars.mds.yandex.net";

    @JsonIgnore
    private Long relevance;
    private String title;
    private String icon;
    private String platform;
    private String bundle;
    private String author;

    @JsonProperty("storeId")
    private String appId;
    private String region;
    private String url;

    public UacSaasAppDto(Long relevance, Map<String, String> data, String url) {
        this.relevance = relevance;
        this.title = data.getOrDefault(AttributeNames.TITLE.getSaasName(), "");
        this.icon = data.getOrDefault(AttributeNames.ICON.getSaasName(), "");
        if (!icon.equals("null")) {
            this.icon = ICON_URL.concat(this.icon);
        }
        this.platform = data.getOrDefault(AttributeNames.PLATFORM.getSaasName(), "");
        this.bundle = data.getOrDefault(AttributeNames.BUNDLE.getSaasName(), "");
        this.author = data.getOrDefault(AttributeNames.AUTHOR.getSaasName(), "");
        this.appId = data.getOrDefault(AttributeNames.APP_ID.getSaasName(), "");
        this.region = data.getOrDefault(AttributeNames.REGION.getSaasName(), "");
        this.url = url;
    }

    public Long getRelevance() {
        return relevance;
    }

    public void setRelevance(Long relevance) {
        this.relevance = relevance;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getIcon() {
        return icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public String getPlatform() {
        return platform;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public String getBundle() {
        return bundle;
    }

    public void setBundle(String bundle) {
        this.bundle = bundle;
    }

    public String getAuthor() {
        return author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getAppId() {
        return appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getRegion() {
        return region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

}
