package ru.yandex.partner.jsonapi.service

import NPartner.Page
import com.fasterxml.jackson.databind.JsonNode
import org.springframework.stereotype.Service
import ru.yandex.partner.core.block.BlockUniqueIdConverter
import ru.yandex.partner.core.bs.BkDataRepository
import ru.yandex.partner.core.entity.block.model.BaseBlock
import ru.yandex.partner.jsonapi.crnk.exceptions.CrnkResponseStatusException
import ru.yandex.partner.jsonapi.utils.PkCheckerUtils
import ru.yandex.partner.libs.bs.json.BkDataConverter
import ru.yandex.partner.libs.exceptions.HttpErrorStatusEnum

@Service
class ApiBkDataService(
    private val bkDataRepository: BkDataRepository<BaseBlock, Page.TPartnerPage.TBlock>
) {
    private val bkDataConverter: BkDataConverter = BkDataConverter()

    fun getBkData(pk: String): JsonNode {
        return if (PkCheckerUtils.isPageBkData(pk)) {
            throw CrnkResponseStatusException(HttpErrorStatusEnum.ERROR__NOT_IMPLEMENTED)
        } else if (PkCheckerUtils.isBlockBkData(pk)) {
            val id = BlockUniqueIdConverter.convertToUniqueId(pk)

            val bkDataPb = bkDataRepository.getBkData(listOf(id)).firstOrNull()
                ?: throw CrnkResponseStatusException(HttpErrorStatusEnum.ERROR__NOT_FOUND)

            bkDataConverter.convertProtoToJsonTree(bkDataPb)
        } else {
            throw CrnkResponseStatusException(HttpErrorStatusEnum.ERROR__PARAMS)
        }
    }
}
