package ru.yandex.partner.jsonapi.service;

import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import io.crnk.core.boot.CrnkBoot;
import io.crnk.core.engine.http.HttpRequestContext;
import io.crnk.servlet.CrnkFilter;
import io.crnk.servlet.internal.ServletRequestContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.partner.jsonapi.crnk.DynamicModule;
import ru.yandex.partner.jsonapi.crnk.DynamicResourceRepository;
import ru.yandex.partner.jsonapi.crnk.exceptions.CrnkResponseStatusException;
import ru.yandex.partner.jsonapi.messages.JsonapiErrorMsg;
import ru.yandex.partner.libs.exceptions.HttpErrorStatusEnum;
import ru.yandex.partner.libs.rbac.userrole.Pair;

@Service
public class CommonResponseService {

    protected final CrnkAdditionalDataService crnkAdditionalDataService;
    protected final DynamicModule dynamicModule;
    protected final String webPathPrefix;
    protected final String defaultCharacterEncoding;
    protected final ServletConfig servletConfig;

    @Autowired
    public CommonResponseService(DynamicModule dynamicModule,
                                 CrnkAdditionalDataService crnkAdditionalDataService,
                                 CrnkFilter crnkFilter,
                                 CrnkBoot crnkBoot,
                                 ServletConfig servletConfig) {
        this.crnkAdditionalDataService = crnkAdditionalDataService;
        this.dynamicModule = dynamicModule;
        this.webPathPrefix = crnkBoot.getWebPathPrefix();
        this.defaultCharacterEncoding = crnkFilter.getDefaultCharacterEncoding();
        this.servletConfig = servletConfig;
    }

    public Pair<HttpRequestContext, DynamicResourceRepository<?>> commonResponse(
            HttpServletRequest request,
            HttpServletResponse response,
            String resourceType
    ) {
        var repository = dynamicModule.getDynamicResourceRepository(resourceType);

        if (repository == null) {
            throw new CrnkResponseStatusException(HttpErrorStatusEnum.ERROR__NOT_FOUND, JsonapiErrorMsg.NOT_FOUND);
        }

        return new Pair<>(getRequestContext(request, response), repository);
    }

    public HttpRequestContext getRequestContext(HttpServletRequest request, HttpServletResponse response) {
        ServletRequestContext context = new ServletRequestContext(servletConfig.getServletContext(), request,
                response, webPathPrefix, defaultCharacterEncoding);
        response.setContentType("application/vnd.api+json");
        response.setCharacterEncoding(defaultCharacterEncoding);
        return HttpRequestContext.create(context);
    }
}
