package ru.yandex.partner.jsonapi.service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.model.ModelProperty;
import ru.yandex.partner.core.validation.defects.presentation.ModelPropertyPresentationNameService;
import ru.yandex.partner.jsonapi.crnk.fields.ApiField;
import ru.yandex.partner.jsonapi.models.ApiModel;

@ParametersAreNonnullByDefault
@Service
public class ModelPropertyPresentationNameServiceImpl implements ModelPropertyPresentationNameService {
    private final Map<Key, String> map;

    @Autowired
    public ModelPropertyPresentationNameServiceImpl(List<ApiModel<?>> apiModels) {
        map = new HashMap<>();
        for (ApiModel<?> apiModel : apiModels) {
            Class<?> modelClass = apiModel.getModelClass();
            for (ApiField<?> field : apiModel.getFields()) {
                if (field.hasCoreValue()) {
                    var key = new Key(modelClass, field.getModelPath().lastProperty());
                    var oldValue = map.put(key, field.getJsonName());

                    if (oldValue != null) {
                        throw new RuntimeException("Duplicate key: " + key + ". OldValue: " + oldValue +
                                ". CurValue: " + field.getJsonName());
                    }
                }
            }
        }
    }

    @Override
    public String getPresentationName(Class<?> modelClass, ModelProperty<?, ?> modelProperty) {
        return Objects.requireNonNull(
                map.get(new Key(modelClass, modelProperty)), "Cannot find jsonName for property " + modelProperty);
    }

    private record Key(Class<?> modelClass, ModelProperty<?, ?> modelProperty) {
    }
}
