package ru.yandex.partner.jsonapi.service;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class MultiIterator<E> implements Iterator<E> {
    private final List<Iterator<E>> iterators;
    private int position;

    public MultiIterator(List<Iterator<E>> iterators) {
        this.iterators = new ArrayList<>(iterators);
        if (iterators.isEmpty()) {
            position = -1;
        } else {
            position = 0;
        }
    }

    @Override
    public boolean hasNext() {
        if (position < 0) {
            return false;
        } else {
            while (position >= 0 && !iterators.get(position).hasNext()) {
                iterators.remove(position);
                if (iterators.isEmpty()) {
                    position = -1;
                } else if (position >= iterators.size()) {
                    position = 0;
                }
            }

            return position >= 0;
        }
    }

    @Override
    public E next() {
        if (hasNext()) {
            var value = iterators.get(position).next();

            position++;
            if (position >= iterators.size()) {
                position = 0;
            }

            return value;
        } else {
            throw new IndexOutOfBoundsException("iterators is empty");
        }
    }
}
