package ru.yandex.partner.jsonapi.utils

import ru.yandex.direct.model.ModelWithId
import ru.yandex.partner.core.entity.common.editablefields.EditableFieldsService
import ru.yandex.partner.jsonapi.constants.CrnkConstants
import ru.yandex.partner.jsonapi.crnk.authorization.actions.ActionsAuthorizationService
import ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRules
import ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRulesService
import ru.yandex.partner.jsonapi.crnk.fields.ApiFieldsAccessRulesServiceImpl
import ru.yandex.partner.jsonapi.crnk.fields.EditableData
import ru.yandex.partner.jsonapi.models.AccessFunctionComposite
import ru.yandex.partner.jsonapi.models.ApiModelPart
import ru.yandex.partner.jsonapi.models.common.ApiAvailableFieldsModelPart
import ru.yandex.partner.jsonapi.models.common.ApiEditableFieldsModelPart
import ru.yandex.partner.libs.auth.facade.AuthenticationFacade

object ConfigurationUtils {

    fun <M : ModelWithId> configureAvailableFields(
        modelParts: MutableList<ApiModelPart<M>>,
        functionComposite: AccessFunctionComposite<M>,
        authenticationFacade: AuthenticationFacade,
        fieldsCompatibilityService: FieldsCompatibilityService? = null): ApiFieldsAccessRulesService<M> {

        val apiFields = modelParts.flatMap { it.fields }

        val apiFieldsAvailableRules = ApiFieldsAccessRulesServiceImpl(
            ApiFieldsAccessRules.build(
                apiFields.map { it.availableFunction },
                functionComposite))
        modelParts.add(
            ApiAvailableFieldsModelPart(apiFieldsAvailableRules = apiFieldsAvailableRules,
                authenticationFacade = authenticationFacade,
                availableFieldJsonName = CrnkConstants.AVAILABLE_FIELDS_FIELD_NAME,
                editableFieldJsonName = CrnkConstants.EDITABLE_FIELDS_FIELD_NAME,
                fieldsCompatibilityService = fieldsCompatibilityService))

        return apiFieldsAvailableRules
    }


    fun <M : ModelWithId> configureEditableFields(
        modelParts: MutableList<ApiModelPart<M>>,
        functionComposite: AccessFunctionComposite<M>,
        authenticationFacade: AuthenticationFacade,
        actionsAuthorizationService: ActionsAuthorizationService<M>,
        editableFieldsService: EditableFieldsService<in M>): ApiFieldsAccessRulesService<EditableData<M>> {

        val apiFields = modelParts.flatMap { it.fields }

        val apiFieldsEditableRules = ApiFieldsAccessRulesServiceImpl(
            ApiFieldsAccessRules.build(
                apiFields.mapNotNull { it.editableFunction },
                functionComposite))
        modelParts.add(
            ApiEditableFieldsModelPart(apiFieldsEditableRules = apiFieldsEditableRules,
                authenticationFacade = authenticationFacade,
                actionsAuthorizationService = actionsAuthorizationService,
                editableFieldsService = editableFieldsService,
                apiFields = apiFields))

        return apiFieldsEditableRules
    }

}
