package ru.yandex.partner.jsonapi.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.DefectInfo;
import ru.yandex.direct.validation.result.PathHelper;
import ru.yandex.partner.core.validation.defects.DefectInfoBuilder;
import ru.yandex.partner.core.validation.defects.presentation.CommonValidationMsg;

@ParametersAreNonnullByDefault
public class ConvertingUtils {
    private ConvertingUtils() {
        // utils
    }

    public static List<DefectInfo<Defect<?>>> stringsToLong(List<String> strings, Consumer<Long> consumer) {
        var defectInfos = new ArrayList<DefectInfo<Defect<?>>>(strings.size());


        int index = 0;
        for (String string : strings) {
            try {
                consumer.accept(Long.valueOf(string));
            } catch (NumberFormatException e) {
                defectInfos.add(DefectInfoBuilder.of(CommonValidationMsg.DATA_MUST_BE_INTEGER_NUMBER)
                        .withPath(PathHelper.path(PathHelper.index(index)))
                        .withValue(string).build());
            }
            index++;
        }

        return defectInfos;
    }
}
