package ru.yandex.partner.jsonapi.utils;


import java.util.function.BinaryOperator;

public class MergeUtils {

    private MergeUtils() {
        // Utils
    }

    public static <T> BinaryOperator<T> uniqMerge() {
        return (t, t2) -> {
            throw new IllegalStateException(
                    String.format("Duplicate key (attempted merging values %s and %s)", t, t2)
            );
        };
    }
}
