package ru.yandex.partner.jsonapi.utils;

import java.io.IOException;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;

public class PerlLikePrettyPrinter extends DefaultPrettyPrinter {

    public PerlLikePrettyPrinter() {
        DefaultPrettyPrinter.Indenter indenter = new DefaultIndenter("   ", DefaultIndenter.SYS_LF);
        indentObjectsWith(indenter);
        indentArraysWith(indenter);
    }

    @Override
    public void writeEndObject(JsonGenerator g, int nrOfEntries) throws IOException {
        if (nrOfEntries < 1) {
            if (!_objectIndenter.isInline()) {
                --_nesting;
            }
            g.writeRaw('}');
        } else {
            super.writeEndObject(g, nrOfEntries);
        }

        if (_nesting == 0) {
            g.writeRaw('\n');
        }
    }

    @Override
    public void writeEndArray(JsonGenerator g, int nrOfValues) throws IOException {
        if (nrOfValues < 1) {
            if (!_objectIndenter.isInline()) {
                --_nesting;
            }
            g.writeRaw(']');
        } else {
            super.writeEndArray(g, nrOfValues);
        }

        if (_nesting == 0) {
            g.writeRaw('\n');
        }
    }

    @Override
    public PerlLikePrettyPrinter createInstance() {
        return new PerlLikePrettyPrinter();
    }
}
