package ru.yandex.partner.jsonapi.utils

object PkCheckerUtils {
    private val pageRegex: Regex = Regex("^[1-9][0-9]*\\z")
    private val blockRegex: Regex = Regex("^[A-Z]+-[A-Z]+-\\d+-\\d+\\z")

    fun isPageBkData(pk: String): Boolean {
        return pageRegex.matches(pk)
    }

    fun isBlockBkData(pk: String): Boolean {
        return blockRegex.matches(pk)
    }

}
