package ru.yandex.partner.jsonapi.utils.function;

import java.util.List;
import java.util.Map;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.model.ModelProperty;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.DefectInfo;

/**
 * @param <T> входящий параметр 1
 * @param <U> входящий параметр 2
 * @see ListPriorityBatchBiFunction -
 * когда конвертация одного элемента ТРЕБУЕТ внешних ресурсов (БД, внешние сервисы и тп)
 * @see OnePriorityBatchBiFunction -
 * когда конвертация одного элемента НЕ ТРЕБУЕТ внешних ресурсов (БД, внешние сервисы и тп)
 */
@ParametersAreNonnullByDefault
public interface BatchBiFunction<T, U> {

    /**
     * размер var1 должен быть равен размеру var2
     *
     * @return мапа дефектов, ключ - индекс из входящего листа, значение - список дефектов
     */
    @Nullable
    Map<Integer, List<DefectInfo<Defect<?>>>> acceptList(List<T> var1, List<U> var2);

    /**
     * @return список дефектов
     */
    @Nullable
    List<DefectInfo<Defect<?>>> acceptOne(T var1, @Nullable U var2);

    static <T, U> OnePriorityBatchBiFunction<T, U> byModelProperty(ModelProperty<? super T, U> modelProperty) {
        return new OnePriorityBatchBiFunction<>() {
            @Nullable
            @Override
            public List<DefectInfo<Defect<?>>> acceptOne(T var1, @Nullable U var2) {
                modelProperty.set(var1, var2);
                return null;
            }
        };
    }

    static <T, U> OnePriorityBatchBiFunction<T, U> one(OnePriorityBatchBiFunction<T, U> batchBiFunction) {
        return batchBiFunction;
    }

    static <T, U> ListPriorityBatchBiFunction<T, U> many(ListPriorityBatchBiFunction<T, U> batchBiFunction) {
        return batchBiFunction;
    }
}
