package ru.yandex.partner.jsonapi.utils.function;

import java.util.List;

/**
 * @param <T> входящий параметр
 * @param <R> возвращаемый параметр
 * @see ListPriorityBatchFunction -
 * когда конвертация одного элемента ТРЕБУЕТ внешних ресурсов (БД, внешние сервисы и тп)
 * @see OnePriorityBatchFunction -
 * когда конвертация одного элемента НЕ ТРЕБУЕТ внешних ресурсов (БД, внешние сервисы и тп)
 */
public interface BatchFunction<T, R> {
    List<R> applyList(List<T> tList);

    R applyOne(T t);

    static <T, R> OnePriorityBatchFunction<T, R> one(OnePriorityBatchFunction<T, R> batchFunction) {
        return batchFunction;
    }

    static <T, R> ListPriorityBatchFunction<T, R> many(ListPriorityBatchFunction<T, R> batchFunction) {
        return batchFunction;
    }
}
