package ru.yandex.partner.jsonapi.utils.function;

import java.util.ArrayList;
import java.util.List;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.DefectInfo;

@ParametersAreNonnullByDefault
@FunctionalInterface
public interface ListPriorityBatchBiFunction<T, U> extends BatchBiFunction<T, U> {
    @Override
    default List<DefectInfo<Defect<?>>> acceptOne(T var1, @Nullable U var2) {
        var nullableList = new ArrayList<U>(1);
        nullableList.add(var2);
        var map = acceptList(List.of(var1), nullableList);
        return map != null
                ? map.get(0)
                : null;
    }
}
