package ru.yandex.partner.jsonapi.utils.function;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.DefectInfo;

@ParametersAreNonnullByDefault
@FunctionalInterface
public interface OnePriorityBatchBiFunction<T, U> extends BatchBiFunction<T, U> {

    @Override
    @Nullable
    default Map<Integer, List<DefectInfo<Defect<?>>>> acceptList(List<T> var1, List<U> var2) {
        if (var1.size() != var2.size()) {
            throw new IndexOutOfBoundsException("Size must be equal. " +
                    "var1.size() = " + var1.size() + "; var2.size() = " + var2.size());
        }

        Iterator<T> tIterator = var1.iterator();
        Iterator<U> uIterator = var2.iterator();

        var defectInfosMap = new HashMap<Integer, List<DefectInfo<Defect<?>>>>(var1.size());
        int index = 0;
        while (tIterator.hasNext()) {
            T t = tIterator.next();
            var defectInfos = acceptOne(t, uIterator.next());
            if (defectInfos != null) {
                defectInfosMap.put(index, defectInfos);
            }
            index++;
        }

        return defectInfosMap;
    }
}
