package ru.yandex.partner.jsonapi.utils.function;

import java.util.List;
import java.util.stream.Collectors;

@FunctionalInterface
public interface OnePriorityBatchFunction<T, R> extends BatchFunction<T, R> {

    @Override
    default List<R> applyList(List<T> tList) {
        return tList.stream().map(this::applyOne).collect(Collectors.toList());
    }
}
