package ru.yandex.partner.jsonapi.validation;

import java.lang.reflect.Field;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;

import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.validation.result.MappingPathNodeConverter;
import ru.yandex.direct.validation.result.PathNodeConverter;
import ru.yandex.direct.validation.result.PathNodeConverterProvider;

public class AnnotationPathNodeConverterProvider implements PathNodeConverterProvider {
    private static final PathNodeConverterProvider INSTANCE = new AnnotationPathNodeConverterProvider();

    private final Map<Class<?>, PathNodeConverter> converters = new ConcurrentHashMap<>();

    private AnnotationPathNodeConverterProvider() {
        // jvm singleton
    }

    public static PathNodeConverterProvider getInstance() {
        return INSTANCE;
    }

    @Override
    public PathNodeConverter getConverter(Class clazz) {
        if (clazz.isInterface()) {
            return null;
        }

        return converters.computeIfAbsent(clazz, this::createConverter);
    }

    private PathNodeConverter createConverter(Class<?> clazz) {
        Field[] fields = clazz.getDeclaredFields();

        MappingPathNodeConverter.Builder converter = MappingPathNodeConverter.builder(clazz.getSimpleName());

        Stream.of(fields)
                .map(this::getFieldMapping)
                .filter(Objects::nonNull)
                .forEach(entry -> converter.replace(entry.getKey(), entry.getValue()));

        return converter.build();
    }

    @Nullable
    private Map.Entry<String, String> getFieldMapping(Field field) {
        return Stream.of(field.getAnnotationsByType(JsonProperty.class))
                .filter(prop -> prop.value().length() > 0)
                .findFirst()
                .map(prop -> Map.entry(field.getName(), prop.value()))
                .orElse(null);
    }
}
