package ru.yandex.partner.jsonapi;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.ContextHierarchy;

import ru.yandex.partner.core.configuration.AdfoxGraphqlTestConfig;
import ru.yandex.partner.core.configuration.BkDataTestConfiguration;
import ru.yandex.partner.core.configuration.MockFormatSystemConfiguration;
import ru.yandex.partner.jsonapi.configuration.AuthTestConfiguration;
import ru.yandex.partner.jsonapi.configuration.BalanceTestConfiguration;
import ru.yandex.partner.jsonapi.configuration.FilterTestConfiguration;
import ru.yandex.partner.jsonapi.configuration.MemcachedTestConfiguration;
import ru.yandex.partner.jsonapi.configuration.TagsTestConfiguration;
import ru.yandex.partner.jsonapi.configuration.TestSaasConfiguration;
import ru.yandex.partner.jsonapi.configuration.i18n.I18nTestConfiguration;
import ru.yandex.partner.test.db.MysqlTestConfiguration;
import ru.yandex.partner.unifiedagent.UnifiedAgentTestConfig;

@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
@SpringBootTest(properties = {"spring.main.allow-bean-definition-overriding=true"},
        webEnvironment = SpringBootTest.WebEnvironment.RANDOM_PORT)
@ContextHierarchy({
        @ContextConfiguration(classes = {MysqlTestConfiguration.class,
                AuthTestConfiguration.class, I18nTestConfiguration.class, BalanceTestConfiguration.class,
                FilterTestConfiguration.class, MemcachedTestConfiguration.class, MockFormatSystemConfiguration.class,
                TagsTestConfiguration.class, TestSaasConfiguration.class, AdfoxGraphqlTestConfig.class,
                BkDataTestConfiguration.class, UnifiedAgentTestConfig.class
        }),
})
@Execution(ExecutionMode.SAME_THREAD)
public @interface JsonApiTest {
}
