package ru.yandex.partner.jsonapi.authenticator;

import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.partner.jsonapi.JsonApiTest;
import ru.yandex.partner.jsonapi.configuration.TestAuthenticator;
import ru.yandex.partner.libs.auth.facade.AuthenticationFacade;
import ru.yandex.partner.libs.auth.model.UserAuthentication;

import static org.junit.jupiter.api.Assertions.assertEquals;

@JsonApiTest
public class TestAuthenticatorTest {

    @Autowired
    private AuthenticationFacade authenticationFacade;

    @Autowired
    private TestAuthenticator testAuthenticator;

    @BeforeEach
    public void init() {
        testAuthenticator.authenticate("mocked-yan-manager");
    }

    @AfterEach
    public void cleanup() {
        testAuthenticator.clearAuthentication();
    }

    @Test
    public void helloTest() {
        UserAuthentication authentication = authenticationFacade.getUserAuthentication();
        assertEquals("mocked-yan-manager", authentication.getLogin());
        assertEquals(1015L, authentication.getUid());
        assertEquals("123/avatar-id", authentication.getBlackboxUserInfo().getAvatarId());
    }

}
