package ru.yandex.partner.jsonapi.configuration;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.jooq.DSLContext;
import org.mockito.Mockito;
import org.springframework.boot.test.context.TestConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.security.authentication.AuthenticationManager;

import ru.yandex.inside.passport.blackbox2.BlackboxRequestExecutor;
import ru.yandex.partner.core.entity.user.service.UserAdfoxService;
import ru.yandex.partner.core.entity.user.service.UserService;
import ru.yandex.partner.libs.auth.provider.apikey.ApiKeyAuthenticationProvider;
import ru.yandex.partner.libs.auth.provider.apikey.ApiKeyRpcConfig;
import ru.yandex.partner.libs.auth.provider.cookie.CookieAuthenticationProvider;
import ru.yandex.partner.libs.auth.provider.tvm.TvmAuthenticationProvider;
import ru.yandex.partner.libs.auth.service.FakeLoginService;
import ru.yandex.partner.libs.auth.service.UserDetailsService;
import ru.yandex.partner.libs.extservice.blackbox.BlackboxService;
import ru.yandex.partner.libs.rbac.userrole.UserRoleService;
import ru.yandex.partner.test.db.QueryLogService;
import ru.yandex.passport.tvmauth.TvmClient;

@TestConfiguration
public class AuthTestConfiguration {


    @Bean
    public ApiKeyAuthenticationProvider apiKeyAuthenticationProvider(
            DSLContext dslContext,
            QueryLogService queryLogService,
            ObjectMapper objectMapper,
            ApiKeyRpcConfig apiKeyRpcConfig
    ) {
        return new TestApiKeyAuthenticationProvider(
                "someKey",
                dslContext,
                queryLogService,
                objectMapper,
                apiKeyRpcConfig
        );
    }

    @Bean
    public CookieAuthenticationProvider cookieAuthenticationProvider() {
        return Mockito.mock(CookieAuthenticationProvider.class);
    }

    @Bean
    public TvmAuthenticationProvider tvmAuthenticationProvider() {
        return Mockito.mock(TvmAuthenticationProvider.class);
    }

    @Bean
    public TvmClient tvmClient() {
        return Mockito.mock(TvmClient.class);
    }

    @Bean
    public BlackboxService blackboxService(
            BlackboxRequestExecutor blackboxRequestExecutor, TvmClient tvmClient
    ) {
        return new TestBlackboxService(blackboxRequestExecutor, tvmClient);
    }

    @Bean
    public UserDetailsService userDetailsService(UserService userService,
                                                 UserAdfoxService userAdfoxService,
                                                 UserRoleService userRoleService,
                                                 FakeLoginService fakeLoginService,
                                                 BlackboxService blackboxService,
                                                 QueryLogService queryLogService) {

        return new TestUserDetailsService(
                userService,
                userAdfoxService,
                userRoleService,
                fakeLoginService,
                blackboxService,
                queryLogService);
    }

    @Bean
    TestAuthenticator testAuthenticator(AuthenticationManager authenticationManager) {
        return new TestAuthenticator(authenticationManager);
    }

}
