package ru.yandex.partner.jsonapi.configuration;

import java.io.IOException;

import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

import io.crnk.core.boot.CrnkBoot;
import org.springframework.boot.test.context.TestConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

import ru.yandex.partner.jsonapi.crnk.CustomCrnkFilter;
import ru.yandex.partner.test.utils.TestUtils;

@TestConfiguration
public class FilterTestConfiguration {

    @Bean
    public CustomCrnkFilter customCrnkFilter(CrnkBoot boot, RequestMatcher protectedRequestMatcher,
                                             RequestMappingHandlerMapping mapping) {
        return new CustomCrnkFilter(boot, protectedRequestMatcher, mapping) {

            @Override
            public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException,
                    ServletException {
                ServletRequest servletRequest = req instanceof HttpServletRequest && TestUtils.needSelfUpdate()
                        ? wrapRequest((HttpServletRequest) req) : req;
                super.doFilter(servletRequest, res, chain);
            }

            private HttpServletRequestWrapper wrapRequest(HttpServletRequest req) {
                return new HttpServletRequestWrapper(req) {
                    @Override
                    public StringBuffer getRequestURL() {
                        return new StringBuffer(super.getRequestURL().toString().replaceAll(":\\d+", ":8080"));
                    }
                };
            }
        };
    }

}
