package ru.yandex.partner.jsonapi.configuration;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

import ru.yandex.partner.libs.auth.model.UserAuthenticationHolder;

public class TestAuthenticator {

    private final AuthenticationManager authenticationManager;

    @Autowired
    public TestAuthenticator(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    public void authenticate(String token) {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addHeader("Authorization", "token " + token);
        UserAuthenticationHolder userAuthenticationHolder = new UserAuthenticationHolder(request);
        Authentication authentication = authenticationManager.authenticate(userAuthenticationHolder);
        SecurityContextHolder.getContext().setAuthentication(authentication);
    }

    public void clearAuthentication() {
        SecurityContextHolder.getContext().setAuthentication(null);
    }
}
