package ru.yandex.partner.jsonapi.configuration;

import java.util.Map;
import java.util.Set;

import io.crnk.core.engine.information.resource.ResourceInformation;
import io.crnk.core.engine.query.QueryContext;
import io.crnk.core.queryspec.QuerySpec;
import org.springframework.stereotype.Service;

import ru.yandex.partner.jsonapi.crnk.CustomQuerySpecUrlMapper;
import ru.yandex.partner.jsonapi.crnk.filter.parser.CrnkFilterParser;
import ru.yandex.partner.jsonapi.response.ExceptionToErrorIdMapper;

/**
 * NOTE: There should be an override of the actual QuerySpecUrlMapper
 */
@Service
public class TestQuerySpecUrlMapper extends CustomQuerySpecUrlMapper {
    private String lastCalledType;


    public TestQuerySpecUrlMapper(ExceptionToErrorIdMapper exceptionToErrorIdMapper,
                                  CrnkFilterParser crnkFilterParser) {
        super(exceptionToErrorIdMapper, crnkFilterParser);
    }

    @Override
    public QuerySpec deserialize(ResourceInformation resourceInformation, Map<String, Set<String>> parameterMap,
                                 QueryContext queryContext) {
        QuerySpec querySpec = super.deserialize(resourceInformation, parameterMap, queryContext);

        lastCalledType = querySpec.getResourceType();
        return querySpec;
    }

    public String getLastCalledType() {
        return lastCalledType;
    }
}
