package ru.yandex.partner.jsonapi.configuration;

import java.util.List;
import java.util.Map;
import java.util.Optional;

import org.springframework.boot.test.context.TestConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;

import ru.yandex.partner.libs.extservice.saas.response.ArchiveInfo;
import ru.yandex.partner.libs.extservice.saas.response.Document;
import ru.yandex.partner.libs.extservice.saas.response.Group;
import ru.yandex.partner.libs.extservice.saas.response.Grouping;
import ru.yandex.partner.libs.extservice.saas.response.GtaRelatedAttribute;
import ru.yandex.partner.libs.extservice.saas.response.SaasResponse;
import ru.yandex.partner.libs.extservice.saas.service.UacSaasClient;


@TestConfiguration
public class TestSaasConfiguration {

    private static final Map<String, String> STORE_PLATFORM_MAP = Map.of(
            "google_play", "android",
            "itunes", "ios"
    );

    @Bean
    @Primary
    public UacSaasClient uacSaasClient() {
        return (saasQuery, template, limit, gtaAttributes) -> {
            var response = new SaasResponse();
            String store;
            String storeTag = "s_store:\"";
            if (template == null) {
                store = "google_play";
            } else if (template.contains(storeTag)) {
                int start = template.indexOf(storeTag) + storeTag.length();
                store = template.substring(start, template.indexOf("*", start));
            } else {
                store = "google_play";
            }

            response.setTotalDocCount(List.of(1, 1, 1));
            var grouping = new Grouping();
            var group = new Group();
            var document = new Document();
            var info = new ArchiveInfo();
            info.setGtaRelatedAttribute(List.of(
                    new GtaRelatedAttribute("z_title", "Yandex.Navigator"),
                    new GtaRelatedAttribute("s_icon",
                            "/get-google-play-app-icon/3936215/d632ee8d2f250405aae3109c28b1902a/icon-xld-retina"),
                    new GtaRelatedAttribute("s_platform", STORE_PLATFORM_MAP.get(store)),
                    new GtaRelatedAttribute("s_store", store),
                    new GtaRelatedAttribute("s_bundle_id", "ru.yandex.yandexnavi"),
                    new GtaRelatedAttribute("z_author", "Yandex Apps"),
                    new GtaRelatedAttribute("s_app_id", "ru.yandex.yandexnavi"),
                    new GtaRelatedAttribute("s_region", "ru")
            ));
            info.setUrl("www.navigator.ru");
            document.setArchiveInfo(info);
            document.setRelevance(1L);
            group.setDocument(List.of(document));
            grouping.setGroup(List.of(group));
            response.setGrouping(List.of(grouping));
            return Mono.just(ResponseEntity.of(Optional.of(response)));
        };
    }

}
