package ru.yandex.partner.jsonapi.configuration;

import javax.servlet.http.HttpServletRequest;

import ru.yandex.partner.core.entity.user.service.UserAdfoxService;
import ru.yandex.partner.core.entity.user.service.UserService;
import ru.yandex.partner.libs.auth.model.UserAuthentication;
import ru.yandex.partner.libs.auth.service.FakeLoginService;
import ru.yandex.partner.libs.auth.service.UserDetailsService;
import ru.yandex.partner.libs.extservice.blackbox.BlackboxService;
import ru.yandex.partner.libs.rbac.userrole.UserRoleService;
import ru.yandex.partner.test.db.QueryLogService;

public class TestUserDetailsService extends UserDetailsService {

    private final QueryLogService queryLogService;

    public TestUserDetailsService(UserService userService,
                                  UserAdfoxService userAdfoxService,
                                  UserRoleService userRoleService,
                                  FakeLoginService fakeLoginService,
                                  BlackboxService blackboxService,
                                  QueryLogService queryLogService) {
        super(userService, userAdfoxService, userRoleService, fakeLoginService, blackboxService);
        this.queryLogService = queryLogService;
    }

    @Override
    public UserAuthentication addDetails(UserAuthentication userAuthentication, HttpServletRequest httpServletRequest) {
        return queryLogService.executeNoLogQuery(() -> super.addDetails(userAuthentication, httpServletRequest));
    }
}
