package ru.yandex.partner.jsonapi.configuration.i18n;

import java.util.List;
import java.util.Locale;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.test.context.TestConfiguration;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.web.servlet.LocaleResolver;

import ru.yandex.partner.jsonapi.configuration.locale.PartnerLocaleResolver;
import ru.yandex.partner.libs.i18n.RawMessageSource;

@TestConfiguration
public class I18nTestConfiguration {

    @Bean
    public LocaleResolver localeResolver(@Value("${app.locale.supported:ru,en,tr}") List<Locale> supportedLocales,
                                         @Value("${app.locale.default:ru}") Locale defaultLocale) {
        PartnerLocaleResolver localeResolver = new PartnerLocaleResolver();
        localeResolver.setSupportedLocales(supportedLocales);
        localeResolver.setDefaultLocale(defaultLocale);
        return localeResolver;
    }

    @Bean
    public MessageSource messageSource() {
        // Чтобы вместо переводов брались сами ключи
        // Тогда тесты не будут зависеть от переводов
        return new RawMessageSource();
    }
}
