package ru.yandex.partner.jsonapi.crnk.block.filter;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.junit.jupiter.api.Test;
import org.springframework.context.support.MessageSourceAccessor;

import ru.yandex.partner.core.entity.block.type.commonshowvideoandstrategy.SiteVersionType;
import ru.yandex.partner.dbschema.partner.enums.ContextOnSiteRtbSiteVersion;
import ru.yandex.partner.jsonapi.crnk.filter.description.FilterDictionaryValue;
import ru.yandex.partner.jsonapi.crnk.filter.parser.exceptions.IgnorableFilterParserException;
import ru.yandex.partner.libs.i18n.RawMessageSource;

import static org.junit.jupiter.api.Assertions.fail;

class SiteVersionValueParserAndProviderTest {

    @Test
    void toValues() throws IgnorableFilterParserException {
        SiteVersionValueParserAndProvider siteVersionValueParserAndProvider =
                new SiteVersionValueParserAndProvider(
                        new RawMessageSource(),
                        new HashSet<>(Arrays.asList(SiteVersionType.values()))
                );

        Set<String> keys = siteVersionValueParserAndProvider
                .renderValues(new MessageSourceAccessor(new RawMessageSource()))
                .stream()
                .map(FilterDictionaryValue::getId)
                .map(Objects::toString)
                .collect(Collectors.toSet());

        JsonNode jsonNode = new ObjectMapper().valueToTree(keys);
        try {
            //noinspection unused
            List<ContextOnSiteRtbSiteVersion> list = siteVersionValueParserAndProvider.toValues(jsonNode)
            .stream()
            .map(ContextOnSiteRtbSiteVersion::valueOf)
            .collect(Collectors.toList());
        } catch (IllegalArgumentException e) {
            fail("Some values cannot be parsed", e);
        }
    }
}
