package ru.yandex.partner.jsonapi.crnk.fields;

import java.util.List;
import java.util.Set;

import org.junit.jupiter.api.Test;

import ru.yandex.direct.model.Model;
import ru.yandex.partner.jsonapi.models.AvailableFunctionComposite;
import ru.yandex.partner.libs.auth.model.UserAuthentication;

import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.mockito.Mockito.mock;

class ApiFieldsAccessRulesServiceImplTest {

    @Test
    void calculateEmpty() {
        Set<String> result = new ApiFieldsAccessRulesServiceImpl<Model>(
                ApiFieldsAccessRules.build(List.of(), mock(AvailableFunctionComposite.class))
        ).calculate(mock(UserAuthentication.class), mock(Model.class));

        assertEquals(Set.of(), result);
    }

    @Test
    void calculate() {
        Set<String> result = new ApiFieldsAccessRulesServiceImpl<Model>(
                ApiFieldsAccessRules.build(
                        List.of(
                                builder -> builder.always("always_field1"),
                                builder -> builder.checkable("checkable_field1",
                                        new ApiFieldsAccessRulesFunction<>((u, o) -> true)),
                                builder -> builder.checkable("checkable_field2",
                                        new ApiFieldsAccessRulesFunction<>((u, o) -> false)),
                                builder -> builder.sameAs("depend_field1", "checkable_field1"),
                                builder -> builder.sameAs("depend_field2", "checkable_field2"),
                                builder -> builder.always("always_field2")
                        ), mock(AvailableFunctionComposite.class)
                )).calculate(mock(UserAuthentication.class), mock(Model.class));

        assertEquals(
                Set.of("always_field1", "always_field2", "checkable_field1", "depend_field1"),
                result
        );
    }
}
