package ru.yandex.partner.jsonapi.crnk.fields;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;

import org.junit.jupiter.api.Test;

import ru.yandex.direct.multitype.entity.LimitOffset;
import ru.yandex.partner.core.entity.block.model.RtbBlock;
import ru.yandex.partner.core.utils.OrderBy;
import ru.yandex.partner.libs.auth.model.UserAuthentication;

import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.junit.jupiter.api.Assertions.assertNull;
import static org.mockito.Mockito.mock;

class QueryParamsContextTest {

    UserAuthentication userAuthentication = mock(UserAuthentication.class);
    RtbBlock rtbBlock = new RtbBlock();
    Function<String, List<OrderBy>> mockFunction = s -> Collections.emptyList();

    @Test
    void basic() {
        QueryParamsContext<RtbBlock> context = new QueryParamsContext<>(
                Collections.emptyMap(), userAuthentication, rtbBlock, mockFunction);

        List<OrderBy> emptyOrderByList = new ArrayList<>();

        context.putExtra("page_id", emptyOrderByList.getClass(), emptyOrderByList);

        List<OrderBy> result = (List<OrderBy>) context.getExtra("page_id", emptyOrderByList.getClass());

        assertEquals(emptyOrderByList, result);
    }

    @Test
    void returnsNullWhenWasNotPut() {
        QueryParamsContext<RtbBlock> context = new QueryParamsContext<>(
                Collections.emptyMap(), userAuthentication, rtbBlock, mockFunction);

        context.putExtra("page_id", List.class, List.of("other-param"));

        LimitOffset limitOffset = context.getExtra("page_id", LimitOffset.class);
        assertNull(limitOffset);
    }
}
