package ru.yandex.partner.jsonapi.crnk.multistate;

import java.util.List;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

import ru.yandex.partner.core.multistate.user.UserMultistate;

class MultistateServiceTest {
    private static MultistateService multistateService;

    @BeforeAll
    static void init() {
        multistateService = new MultistateService();
    }

    @ParameterizedTest
    @MethodSource("testData")
    public void testRenderMultistateName(Long multistateValue, String multistateName) {
        Assertions.assertEquals(multistateName,
                multistateService.renderMultistateName(new UserMultistate(multistateValue)));
    }


    public static List<Arguments> testData() {
        return List.of(
                Arguments.of(0L, "New"),
                Arguments.of(1L, "Contacts provided"),
                Arguments.of(2L, "Need create partner in BannerStore"),
                Arguments.of(3L, "Contacts provided.\nNeed create partner in BannerStore"),
                Arguments.of(9L, "Contacts provided.\nNeed YAN contract")
        );
    }
}
