package ru.yandex.partner.jsonapi.crnk.user;

import java.util.Collection;
import java.util.Map;

import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.springframework.context.MessageSource;

import ru.yandex.partner.core.entity.common.editablefields.EditableFieldsService;
import ru.yandex.partner.core.entity.dictionary.moderationreason.ModerationReasonService;
import ru.yandex.partner.core.entity.user.model.User;
import ru.yandex.partner.core.entity.user.multistate.UserMultistateExpressionParser;
import ru.yandex.partner.core.entity.user.multistate.UserMultistateGraph;
import ru.yandex.partner.core.service.integration.balance.BalanceDocumentService;
import ru.yandex.partner.jsonapi.crnk.authorization.request.RequestAuthorizationService;
import ru.yandex.partner.jsonapi.crnk.filter.CrnkFilter;
import ru.yandex.partner.jsonapi.crnk.filter.description.FilterDescriptionService;
import ru.yandex.partner.jsonapi.crnk.filter.description.provider.ModerationReasonDictionaryValuesProvider;
import ru.yandex.partner.jsonapi.crnk.filter.description.provider.RolesDictionaryValuesProvider;
import ru.yandex.partner.jsonapi.crnk.filter.description.provider.UserTypeDictionaryValuesProvider;
import ru.yandex.partner.jsonapi.crnk.multistate.MultistateService;
import ru.yandex.partner.jsonapi.crnk.user.authorization.UserAuthorizationPolicy;
import ru.yandex.partner.jsonapi.crnk.user.authorization.actions.UserActionsAuthorizationService;
import ru.yandex.partner.jsonapi.models.user.ApiUserConfiguration;
import ru.yandex.partner.jsonapi.models.user.ApiUserModelMetaData;
import ru.yandex.partner.libs.auth.RightHolder;
import ru.yandex.partner.libs.auth.facade.AuthenticationFacade;
import ru.yandex.partner.libs.auth.model.UserAuthentication;
import ru.yandex.partner.test.utils.TestUtils;

import static org.mockito.ArgumentMatchers.any;
import static org.mockito.ArgumentMatchers.anyBoolean;
import static org.mockito.ArgumentMatchers.anyString;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.when;

public class UserCrnkModelFiltersTest {

    private AuthenticationFacade authenticationFacade;

    private BalanceDocumentService balanceDocumentService;

    private UserMultistateGraph userMultistateGraph;
    private UserMultistateExpressionParser userMultistateExpressionParser;

    private ModerationReasonService moderationReasonService;

    private RolesDictionaryValuesProvider rolesDictionaryValuesProvider;
    private UserTypeDictionaryValuesProvider userTypeDictionaryValuesProvider;
    private ModerationReasonDictionaryValuesProvider moderationReasonDictionaryValuesProvider;

    private UserCrnkModelFilters userCrnkModelFilters;
    private FilterDescriptionService filterDescriptionService;

    private RequestAuthorizationService requestAuthorizationService;
    private UserAuthorizationPolicy userAuthorizationPolicy;

    @BeforeEach
    public void init() {
        UserAuthentication ua = mock(UserAuthentication.class);
        when(ua.userHasRight(any(RightHolder.class))).thenReturn(true);

        authenticationFacade = mock(AuthenticationFacade.class);
        when(authenticationFacade.userHasRight(any())).thenReturn(true);
        when(authenticationFacade.getUserAuthentication()).thenReturn(ua);

        balanceDocumentService = mock(BalanceDocumentService.class);

        userMultistateGraph = mock(UserMultistateGraph.class);
        userMultistateExpressionParser = mock(UserMultistateExpressionParser.class);

        moderationReasonService = mock(ModerationReasonService.class);
        when(moderationReasonService.getDictionaryValues(anyString(), anyBoolean()))
                .thenReturn(Map.of(1L, "Some reason"));

        rolesDictionaryValuesProvider = new RolesDictionaryValuesProvider();
        userTypeDictionaryValuesProvider = new UserTypeDictionaryValuesProvider(authenticationFacade);
        moderationReasonDictionaryValuesProvider = new ModerationReasonDictionaryValuesProvider(
                moderationReasonService, authenticationFacade);

        var apiUserModel = new ApiUserConfiguration().apiUserModel(
                new ApiUserModelMetaData(),
                mock(MultistateService.class),
                mock(ModerationReasonService.class),
                authenticationFacade,
                mock(UserActionsAuthorizationService.class),
                userMultistateGraph,
                userMultistateExpressionParser,
                rolesDictionaryValuesProvider,
                balanceDocumentService,
                userTypeDictionaryValuesProvider,
                moderationReasonDictionaryValuesProvider,
                userAuthorizationPolicy,
                mock(ActiveContractCrnkMapper.class),
                mock(AdfoxInfoCrnkMapper.class),
                mock(RoleCrnkMapper.class),
                mock(EditableFieldsService.class),
                mock(MessageSource.class)
        );

        userCrnkModelFilters = new UserCrnkModelFilters(
                apiUserModel
        );

        filterDescriptionService = new FilterDescriptionService();
    }

    @Test
    public void getExposedFilterDescriptionsTest() throws Exception {
        Collection<CrnkFilter<User, ?>> filters = userCrnkModelFilters.getFilters().values();

        TestUtils.compareToDataFromFile(filterDescriptionService.renderDescriptions(filters),
                UserCrnkModelFiltersTest.class, "exposedFilterDescriptions.json");
    }

}
