package ru.yandex.partner.jsonapi.crnk.user.authorization;

import java.util.Set;

import com.google.common.collect.Sets;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

import ru.yandex.partner.core.entity.user.model.User;
import ru.yandex.partner.libs.auth.model.UserAuthentication;
import ru.yandex.partner.libs.authorization.decision.AuthorizationDecision;
import ru.yandex.partner.libs.rbac.role.RoleSet;

import static org.assertj.core.api.Assertions.assertThat;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.when;
import static ru.yandex.partner.libs.rbac.role.RoleSet.INTERNAL_YAN_ADMINISTRATOR;
import static ru.yandex.partner.libs.rbac.role.RoleSet.INTERNAL_YAN_MANAGER;
import static ru.yandex.partner.libs.rbac.role.RoleSet.INTERNAL_YAN_VIEWER;

class AdinsideRuleTest {
    AdinsideRule adinsideRule;

    @BeforeEach
    void beforeEach() {
        adinsideRule = new AdinsideRule();
    }

    @Test
    void authorizePermitInternalManager() {
        UserAuthentication ua = mock(UserAuthentication.class);
        when(ua.getRoles()).thenReturn(Set.of(INTERNAL_YAN_MANAGER));
        AuthorizationDecision<User> authorize = adinsideRule.authorize(ua);
        assertThat(authorize).isNotNull();
        assertThat((Boolean) authorize.match(
                unapplicable -> false,
                permit -> false,
                restrictedPermit -> true,
                deny -> false)
        ).isTrue();
    }

    @Test
    void authorizePermitInternalAdministrator() {
        UserAuthentication ua = mock(UserAuthentication.class);
        when(ua.getRoles()).thenReturn(Set.of(INTERNAL_YAN_ADMINISTRATOR));
        AuthorizationDecision<User> authorize = adinsideRule.authorize(ua);
        assertThat(authorize).isNotNull();
        assertThat((Boolean) authorize.match(
                unapplicable -> false,
                permit -> false,
                restrictedPermit -> true,
                deny -> false)
        ).isTrue();
    }

    @Test
    void authorizePermitInternalViewer() {
        UserAuthentication ua = mock(UserAuthentication.class);
        when(ua.getRoles()).thenReturn(Set.of(INTERNAL_YAN_VIEWER));
        AuthorizationDecision<User> authorize = adinsideRule.authorize(ua);
        assertThat(authorize).isNotNull();
        assertThat((Boolean) authorize.match(
                unapplicable -> false,
                permit -> false,
                restrictedPermit -> true,
                deny -> false)
        ).isTrue();
    }

    @Test
    void authorizeDenyWrongRole() {
        UserAuthentication ua = mock(UserAuthentication.class);
        when(ua.getRoles()).thenReturn(
                Sets.difference(
                        RoleSet.getRoles(),
                        Set.of(INTERNAL_YAN_MANAGER, INTERNAL_YAN_ADMINISTRATOR, INTERNAL_YAN_VIEWER)
                )
        );
        AuthorizationDecision<User> authorize = adinsideRule.authorize(ua);
        assertThat(authorize).isNotNull();
        assertThat(authorize.isUnapplicable()).isTrue();
    }

    @Test
    void authorizeDenyEmpty() {
        UserAuthentication ua = mock(UserAuthentication.class);
        when(ua.getRoles()).thenReturn(Set.of());
        AuthorizationDecision<User> authorize = adinsideRule.authorize(ua);
        assertThat(authorize).isNotNull();
        assertThat(authorize.isUnapplicable()).isTrue();
    }
}
