package ru.yandex.partner.jsonapi.exceptions;

import io.crnk.core.engine.document.ErrorData;
import io.crnk.core.engine.error.ErrorResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.partner.jsonapi.JsonApiTest;
import ru.yandex.partner.jsonapi.crnk.exceptions.mapper.CrnkExceptionMapper;
import ru.yandex.partner.jsonapi.crnk.exceptions.mapper.ErrorDataForProd;
import ru.yandex.partner.jsonapi.crnk.exceptions.mapper.ErrorDataNotForProd;
import ru.yandex.partner.jsonapi.response.ExceptionToErrorIdMapper;
import ru.yandex.partner.jsonapi.response.PartnerExceptionResponseWriter;

@JsonApiTest
public class ExceptionMapperTest {

    @Autowired
    private ExceptionToErrorIdMapper exceptionToErrorIdMapper;

    @Autowired
    private PartnerExceptionResponseWriter partnerExceptionResponseWriter;

    @Test
    void exceptionMapperOnProdTest() {
        CrnkExceptionMapper crnkExceptionMapper = new CrnkExceptionMapper(exceptionToErrorIdMapper,
                new ErrorDataForProd());
        Exception exception = new RuntimeException("Test exception");
        ErrorResponse errorResponse = crnkExceptionMapper.toErrorResponse(exception);
        partnerExceptionResponseWriter.toResponse(exception);
        ErrorData errorData = errorResponse.getErrors().stream().findFirst().get();
        Assertions.assertEquals("500", errorData.getCode());
        Assertions.assertEquals("5", errorData.getId());
        Assertions.assertEquals("Internal Server Error", errorData.getTitle());
        Assertions.assertNull(errorData.getDetail());
    }

    @Test
    void exceptionMapperNotOnProdTest() {
        CrnkExceptionMapper crnkExceptionMapper = new CrnkExceptionMapper(exceptionToErrorIdMapper,
                new ErrorDataNotForProd());
        Exception exception = new RuntimeException("Test exception");
        ErrorResponse errorResponse = crnkExceptionMapper.toErrorResponse(exception);
        partnerExceptionResponseWriter.toResponse(exception);
        ErrorData errorData = errorResponse.getErrors().stream().findFirst().get();
        Assertions.assertEquals("500", errorData.getCode());
        Assertions.assertEquals("5", errorData.getId());
        Assertions.assertEquals("Internal Server Error", errorData.getTitle());
        Assertions.assertEquals("Test exception", errorData.getDetail());
    }
}
