package ru.yandex.partner.jsonapi.i18n;

import java.util.Locale;

import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.MessageSourceAccessor;

import ru.yandex.partner.jsonapi.messages.JsonapiErrorMsg;
import ru.yandex.partner.libs.auth.message.AuthErrorMsg;
import ru.yandex.partner.libs.i18n.GettextMessageSource;
import ru.yandex.partner.libs.i18n.MsgWithArgs;

import static org.junit.jupiter.api.Assertions.assertEquals;

class GettextMessageSourceTest {
    private static MessageSourceAccessor messages;

    @BeforeAll
    static void init() {
        messages = new MessageSourceAccessor(new GettextMessageSource("translations"));
    }


    @Test
    void getTextTest() {

        LocaleContextHolder.setDefaultLocale(new Locale("ru"));

        assertEquals("Internal service error",
                messages.getMessage(JsonapiErrorMsg.INTERNAL_SERVER_ERROR, new Locale("en"))
        );

        assertEquals("Внутренняя ошибка сервиса",
                messages.getMessage(JsonapiErrorMsg.INTERNAL_SERVER_ERROR, new Locale("ru"))
        );

        //empty or unknown locale must fallback to the default one
        assertEquals("Внутренняя ошибка сервиса",
                messages.getMessage(JsonapiErrorMsg.INTERNAL_SERVER_ERROR)
        );

        assertEquals("Внутренняя ошибка сервиса",
                messages.getMessage(JsonapiErrorMsg.INTERNAL_SERVER_ERROR, new Locale("de"))
        );

    }

    @Test
    void getTextWithParams() {

        LocaleContextHolder.setDefaultLocale(new Locale("ru"));

        assertEquals("Invalid service ticket status: Expired",
                messages.getMessage(MsgWithArgs.of(AuthErrorMsg.SERVICE_TICKET_STATUS, "Expired"), new Locale("en"))
        );

        assertEquals("Недопустимый статус сервисного тикета: Expired",
                messages.getMessage(MsgWithArgs.of(AuthErrorMsg.SERVICE_TICKET_STATUS, "Expired"), new Locale("ru"))
        );

        //empty or unknown locale must fallback to the default one
        assertEquals("Недопустимый статус сервисного тикета: Expired",
                messages.getMessage(MsgWithArgs.of(AuthErrorMsg.SERVICE_TICKET_STATUS, "Expired"))
        );

        assertEquals("Недопустимый статус сервисного тикета: Expired",
                messages.getMessage(MsgWithArgs.of(AuthErrorMsg.SERVICE_TICKET_STATUS, "Expired"), new Locale("de"))
        );
    }

}
