package ru.yandex.partner.jsonapi.i18n;

import java.util.Collections;
import java.util.Locale;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

import ru.yandex.partner.libs.i18n.testing.MessageChecker;
import ru.yandex.partner.libs.i18n.testing.MsgNotEnumException;

@TestInstance(TestInstance.Lifecycle.PER_CLASS)
public class TranslationsExistTest {

    private MessageChecker messageChecker;

    @BeforeAll
    public void init() {
        messageChecker = new MessageChecker("ru.yandex.partner", "translations");
    }

    @ParameterizedTest
    @ValueSource(strings = {"ru"})
    public void testAllTranslationsExist(String language) throws MsgNotEnumException {

        Locale locale = new Locale(language);

        Assertions.assertEquals(Collections.emptyMap(), messageChecker.findProblemsMappedByClass(locale),
                "Missing messages for locale " + locale);
    }

}


