package ru.yandex.partner.jsonapi.jackson;

import java.util.List;
import java.util.Objects;

public class TestModel {
    private Integer id;
    private String name;
    private List<Integer> children;
    private List<TestModelAttribute> attributes;
    private TestModelAttribute attribute1;
    private TestModelAttribute attribute2;
    private TestModelAttribute attribute3;

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<Integer> getChildren() {
        return children;
    }

    public void setChildren(List<Integer> children) {
        this.children = children;
    }

    public List<TestModelAttribute> getAttributes() {
        return attributes;
    }

    public void setAttributes(List<TestModelAttribute> attributes) {
        this.attributes = attributes;
    }

    public TestModelAttribute getAttribute1() {
        return attribute1;
    }

    public void setAttribute1(TestModelAttribute attribute1) {
        this.attribute1 = attribute1;
    }

    public TestModelAttribute getAttribute2() {
        return attribute2;
    }

    public void setAttribute2(TestModelAttribute attribute2) {
        this.attribute2 = attribute2;
    }

    public TestModelAttribute getAttribute3() {
        return attribute3;
    }

    public void setAttribute3(TestModelAttribute attribute3) {
        this.attribute3 = attribute3;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TestModel)) {
            return false;
        }
        TestModel testModel = (TestModel) o;
        return Objects.equals(id, testModel.id) &&
                Objects.equals(name, testModel.name) &&
                Objects.equals(children, testModel.children) &&
                Objects.equals(attribute1, testModel.attribute1) &&
                Objects.equals(attribute2, testModel.attribute2) &&
                Objects.equals(attribute3, testModel.attribute3);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, name, children, attribute1, attribute2, attribute3);
    }

    @Override
    public String toString() {
        return "TestModel{" +
                "id=" + id +
                ", name='" + name + '\'' +
                ", children=" + children +
                ", attribute1=" + attribute1 +
                ", attribute2=" + attribute2 +
                ", attribute3=" + attribute3 +
                '}';
    }
}
