package ru.yandex.partner.jsonapi.jackson;

import java.util.Objects;

public class TestModelAttribute {
    private Integer id;
    private String name;

    public TestModelAttribute() {
    }

    public int getId() {
        return id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public TestModelAttribute withId(int id) {
        this.id = id;
        return this;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public TestModelAttribute withName(String name) {
        this.name = name;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TestModelAttribute)) {
            return false;
        }
        TestModelAttribute that = (TestModelAttribute) o;
        return Objects.equals(id, that.id) &&
                Objects.equals(name, that.name);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, name);
    }

    @Override
    public String toString() {
        return "TestModelAttribute{" +
                "id=" + id +
                ", name='" + name + '\'' +
                '}';
    }
}
