package ru.yandex.partner.jsonapi.multistate.dto;

import java.util.Map;
import java.util.Set;

import com.fasterxml.jackson.annotation.JsonInclude;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

public class MultistateConfigJson {

    private final Set<String> actions;
    private final Map<String, Integer> bits;
    private final Map<String, Map<String, Long>> graph;
    @JsonInclude(NON_NULL)
    private final Map<String, StateFlagOptsJson> opts;
    @JsonInclude(NON_NULL)
    private final Map<String, String> rights;

    public MultistateConfigJson(Set<String> actions, Map<String, Integer> bits, Map<String, Map<String, Long>> graph,
                                Map<String, StateFlagOptsJson> opts, Map<String, String> rights) {
        this.actions = actions;
        this.bits = bits;
        this.graph = graph;
        this.opts = opts;
        this.rights = rights;
    }

    public Set<String> getActions() {
        return actions;
    }

    public Map<String, Integer> getBits() {
        return bits;
    }

    public Map<String, Map<String, Long>> getGraph() {
        return graph;
    }

    public Map<String, StateFlagOptsJson> getOpts() {
        return opts;
    }

    public Map<String, String> getRights() {
        return rights;
    }

}
