package ru.yandex.partner.jsonapi.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

import org.junit.jupiter.api.Test;

import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.junit.jupiter.api.Assertions.assertFalse;
import static org.junit.jupiter.api.Assertions.assertThrows;

class MultiIteratorTest {


    @Test
    void empty() {
        var iterator = new MultiIterator<Integer>(List.of());

        assertFalse(iterator.hasNext());

        assertThrows(IndexOutOfBoundsException.class, iterator::next);
    }

    @Test
    void emptyIterators() {
        var iterator = new MultiIterator<Integer>(List.of(Collections.emptyIterator(), Collections.emptyIterator(),
                Collections.emptyIterator(), Collections.emptyIterator()));

        assertFalse(iterator.hasNext());

        assertThrows(IndexOutOfBoundsException.class, iterator::next);
    }

    @Test
    void emptyIteratorWithNotEmpty() {
        var iterator = new MultiIterator<>(List.of(Collections.emptyIterator(), List.of(1, 2, 3).iterator(),
                Collections.emptyIterator(), Collections.emptyIterator()));

        var expected = List.of(1, 2, 3);

        assertEquals(expected, get(iterator));
    }

    @Test
    void notEmptyIterators3() {
        var iterator = new MultiIterator<>(List.of(List.of(1, 4, 7).iterator(),
                List.of(2, 5, 8).iterator(), List.of(3, 6, 9).iterator()));

        var expected = List.of(1, 2, 3, 4, 5, 6, 7, 8, 9);

        assertEquals(expected, get(iterator));
    }

    @Test
    void notEmptyIterators2() {
        var iterator = new MultiIterator<>(List.of(List.of(1, 3, 5, 7, 9).iterator(),
                List.of(2, 4, 6, 8, 10).iterator()));

        var expected = List.of(1, 2, 3, 4, 5, 6, 7, 8, 9, 10);

        assertEquals(expected, get(iterator));
    }


    private <E> List<E> get(Iterator<E> iterator) {
        var list = new ArrayList<E>();

        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }
}
