package ru.yandex.partner.jsonapi.sql;

import io.crnk.core.engine.registry.ResourceRegistry;
import org.springframework.http.HttpStatus;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

import ru.yandex.partner.jsonapi.utils.UrlUtils;

public class HttpGetSqlArgument implements SqlArgument {
    private final String uri;
    private final String login;
    private final String resourcePath;

    public HttpGetSqlArgument(String uri, String login, String resourcePath) {
        this.uri = uri;
        this.login = login;
        this.resourcePath = resourcePath;
    }

    @Override
    public String getResourcePath() {
        return resourcePath;
    }

    @Override
    public void performRequest(WebClient webClient, ResourceRegistry resourceRegistry) {
        try {
            webClient.get()
                    .uri(UrlUtils.replaceAllFields(resourceRegistry, uri))
                    .header("Authorization", "token " + login)
                    .header("Accept", "application/vnd.api+json")
                    .retrieve()
                    .onStatus(HttpStatus::is4xxClientError, clientResponse -> Mono.error(new IgnoreException()))
                    .toBodilessEntity()
                    .block();
        } catch (IgnoreException ignore) {

        }
    }

    @Override
    public String toString() {
        return "HttpGetSqlArgument{" +
                "uri='" + uri + '\'' +
                ", login='" + login + '\'' +
                ", resourcePath='" + resourcePath + '\'' +
                '}';
    }

    private static class IgnoreException extends RuntimeException {

    }
}
