package ru.yandex.partner.jsonapi.sql;

import io.crnk.core.engine.registry.ResourceRegistry;
import org.springframework.http.HttpStatus;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

import ru.yandex.partner.jsonapi.utils.UrlUtils;

public class HttpPostSqlArgument implements SqlArgument {
    private final String uri;
    private final String login;
    private final String resourcePath;
    private final String body;

    public HttpPostSqlArgument(String uri, String login, String resourcePath, String body) {
        this.uri = uri;
        this.login = login;
        this.resourcePath = resourcePath;
        this.body = body;
    }

    @Override
    public String getResourcePath() {
        return resourcePath;
    }

    @Override
    public void performRequest(WebClient webClient, ResourceRegistry resourceRegistry) {
        try {
            webClient.post()
                    .uri(UrlUtils.replaceAllFields(resourceRegistry, uri))
                    .header("Authorization", "token " + login)
                    .header("Content-Type", "application/vnd.api+json")
                    .header("Accept", "application/vnd.api+json")
                    .body(BodyInserters.fromValue(body))
                    .retrieve()
                    .onStatus(HttpStatus::is4xxClientError, clientResponse -> {
                        var bodyy = clientResponse.bodyToMono(String.class);
                        System.out.println(bodyy);
                        return Mono.error(new IgnoreException());
                    })
                    .toBodilessEntity()
                    .block();
        } catch (IgnoreException ignore) {
        }
    }

    private static class IgnoreException extends RuntimeException {

    }

    @Override
    public String toString() {
        return "HttpPostSqlArgument{" +
                "uri='" + uri + '\'' +
                ", login='" + login + '\'' +
                ", resourcePath='" + resourcePath + '\'' +
                ", body='" + body + '\'' +
                '}';
    }
}
