package ru.yandex.partner.jsonapi.utils;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

import ru.yandex.partner.jsonapi.JsonApiTest;
import ru.yandex.partner.test.utils.TestUtils;

@JsonApiTest
class ApiUtilsTest {

    @Autowired
    RequestMappingHandlerMapping mapping;

    @Test
    void t() throws IOException {
        String referenceDataPath = TestUtils.getAbsolutePath("spring-endpoints.txt");
        Collection<String> expected = Files.readAllLines(Path.of(referenceDataPath)).stream()
                .sorted().toList();
        Collection<String> actual = ApiUtils.getSpringEndpoints(mapping).stream()
                .sorted().toList();

        if (TestUtils.needSelfUpdate()) {
            Files.write(Path.of(referenceDataPath), actual);
            Assertions.fail("Resource self_updated. Path = " + referenceDataPath);
        }
        Assertions.assertEquals(expected, actual, "Spring endpoints differs");
    }
}
