package ru.yandex.partner.jsonapi.utils;

import java.io.IOException;
import java.util.stream.Stream;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.jupiter.params.provider.ArgumentsSource;

import static org.junit.jupiter.api.Assertions.assertEquals;

class PerlLikePrettyPrinterTest {
    private ObjectMapper mapper;

    @BeforeEach
    void setUp() {
        mapper = new ObjectMapper();
        mapper.configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, true);
        mapper.configure(SerializationFeature.INDENT_OUTPUT, true);
        mapper.setDefaultPrettyPrinter(new PerlLikePrettyPrinter());
    }

    @ParameterizedTest
    @ArgumentsSource(JsonArgumentProvider.class)
    void pretty(String source, String expected) throws IOException {
        Object obj = mapper.readValue(source, Object.class);
        String actual = mapper.writeValueAsString(obj);


        assertEquals(expected, actual);
    }

}

final class JsonArgumentProvider implements ArgumentsProvider {

    @Override
    public Stream<? extends Arguments> provideArguments(ExtensionContext context) {
        return Stream.of(
                () -> new Object[]{"{}", "{}\n"},
                () -> new Object[]{"{\"array\": []}", "{\n   \"array\" : []\n}\n"},
                () -> new Object[]{"{\"object1\": {\"innerObject1\":{}}}}", "{\n   \"object1\" : {\n      " +
                        "\"innerObject1\" : {}\n   }\n}\n"},
                () -> new Object[]{"[1,2,3]", "[\n   1,\n   2,\n   3\n]\n"},
                () -> new Object[]{"{\"arr1\":[1,2], \"arr2\": []}", "{\n   \"arr1\" : [\n      1,\n      2\n   ]," +
                        "\n   \"arr2\" : []\n}\n"}

        );
    }
}
