package ru.yandex.partner.jsonapi.utils.function;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;

import org.junit.jupiter.api.Test;

import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.DefectInfo;
import ru.yandex.direct.validation.result.Path;
import ru.yandex.direct.validation.result.PathHelper;
import ru.yandex.partner.core.validation.defects.ids.TypeDefectIds;

import static org.junit.jupiter.api.Assertions.assertEquals;

class ListPriorityBatchBiFunctionTest {

    @Test
    void acceptOne() {
        Path emptyPath = PathHelper.emptyPath();
        Defect<?> defect = new Defect<>(TypeDefectIds.INVALID_TYPE);
        var listPriorityBatchFunction = new ListPriorityBatchBiFunction<Integer, Integer>() {
            @Override
            public Map<Integer, List<DefectInfo<Defect<?>>>> acceptList(@Nonnull List<Integer> var1,
                                                                        @Nonnull List<Integer> var2) {
                Integer[] integers = var2.toArray(Integer[]::new);
                Map<Integer, List<DefectInfo<Defect<?>>>> map = new HashMap<>(integers.length);
                for (int i = 0; i < integers.length; i++) {
                    map.put(i, List.of(new DefectInfo<>(emptyPath, integers[i], defect)));

                }
                return map;
            }
        };

        int value = 939393;
        var result = listPriorityBatchFunction.acceptOne(4, value);

        assertEquals(List.of(new DefectInfo<Defect>(emptyPath, value, defect)), result);
    }
}
