package ru.yandex.partner.jsonapi.utils.function;

import java.util.List;
import java.util.stream.Collectors;

import org.junit.jupiter.api.Test;

import static org.junit.jupiter.api.Assertions.assertEquals;

class ListPriorityBatchFunctionTest {

    @Test
    void applyOne() {
        var listPriorityBatchFunction = new ListPriorityBatchFunction<Integer, Integer>() {

            @Override
            public List<Integer> applyList(List<Integer> integers) {
                return integers.stream().map(number -> number * 2).collect(Collectors.toList());
            }
        };

        var result = listPriorityBatchFunction.applyOne(2343);

        assertEquals(4686, result);
    }
}
